<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Savienojums ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die(json_encode(["error" => "Savienojums ar datubāzi neizdevās: " . $conn->connect_error]));
}

session_start();
header('Content-Type: application/json');

// Sesijas pārbaude
$user_id = $_SESSION['user_id'] ?? null;
$role = $_SESSION['work_position'] ?? null;
$action = $_POST['action'] ?? $_GET['action'] ?? null;

// Pārbauda, vai lietotājam ir piekļuve
if (!$user_id || $role !== 'darbinieks') {
    echo json_encode(["error" => "Piekļuve liegta. Tikai darbiniekiem."]);
    exit;
}

// Darba stundu iegūšana
if ($action === "fetch-work-hours") {
    $sql = "SELECT date, clock_in_time, 
                   IF(clock_out_time IS NULL, 'Nav pieejams', clock_out_time) AS clock_out_time,
                   IF(clock_out_time IS NULL, 'Procesā', FORMAT(total_work_hours, 2)) AS total_work_hours
            FROM rb_kvalif_workhours_410 
            WHERE user_id = ? ORDER BY date DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $work_hours = $result->fetch_all(MYSQLI_ASSOC);
    echo json_encode(["data" => $work_hours]);
    exit;
}

// Darba sākuma laika reģistrācija
elseif ($action === "clock-in") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "SELECT * FROM rb_kvalif_workhours_410 WHERE user_id = ? AND date = ? AND clock_out_time IS NULL";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $user_id, $date);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo json_encode(["error" => "Jūs jau esat reģistrējies šodien."]);
    } else {
        $sql = "INSERT INTO rb_kvalif_workhours_410 (user_id, date, clock_in_time) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iss", $user_id, $date, $time);
        if ($stmt->execute()) {
            echo json_encode(["success" => "Darba sākums veiksmīgi reģistrēts plkst. $time."]);
        } else {
            echo json_encode(["error" => "Neizdevās reģistrēt darba sākumu: " . $stmt->error]);
        }
    }
    exit;
}

// Darba beigu laika reģistrācija
elseif ($action === "clock-out") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "SELECT * FROM rb_kvalif_workhours_410 WHERE user_id = ? AND date = ? AND clock_out_time IS NULL";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $user_id, $date);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo json_encode(["error" => "Šodien nav aktīvas darba sesijas."]);
    } else {
        $sql = "UPDATE rb_kvalif_workhours_410 
                SET clock_out_time = ?, 
                    total_work_hours = TIMESTAMPDIFF(SECOND, CONCAT(date, ' ', clock_in_time), CONCAT(date, ' ', ?)) / 3600
                WHERE user_id = ? AND date = ? AND clock_out_time IS NULL";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssis", $time, $time, $user_id, $date);
        if ($stmt->execute()) {
            echo json_encode(["success" => "Darba beigas veiksmīgi reģistrētas plkst. $time."]);
        } else {
            echo json_encode(["error" => "Neizdevās reģistrēt darba beigas: " . $stmt->error]);
        }
    }
    exit;
}

// Ja darbība nav norādīta vai ir nederīga
echo json_encode(["error" => "Nepareiza darbība."]);
$conn->close();
?>